# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdarray import SDArray
from .sddefinition import SDDefinition
from .sdapiobject import SDAPIObject
from .sdresource import SDResource
from .sdapiobject import SDApiError
from .sdresource import EmbedMethod
from .apiexception import APIException

class SDResourceScene(SDResource):
    """
    A scene or mesh resource as it can be found in a SDPackage
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDResourceScene
        """
        super(SDResourceScene, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sGetAvailablePrimitiveDefinitions() -> SDArray[SDDefinition]:
        """
        Get all available primitive definitions. A primitive is a predefined scene provided by Designer (Cube, Sphere, Plane, ...)

        """
        outArray = ctypes.c_void_p()
        _res = sd.getContext().SDResourceScene_sGetAvailablePrimitiveDefinitions(ctypes.byref(outArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outArray, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outArray.value, ownHandle=True)

    @staticmethod
    def sNewFromPrimitiveId(parent : SDAPIObject, primitiveId : str) -> SDResourceScene:
        """
        Create a new SDResourceScene from the specified primitive Id

        :param parent: The parent data that will contains the newly created Resource. Can be SDPackage or SDResourceFolder
        :param primitiveId: The primitive id (See 'sGetAvailablePrimitiveDefinitions' for available primitive definitions)
        """
        outResource = ctypes.c_void_p()
        _res = sd.getContext().SDResourceScene_sNewFromPrimitiveId(parent.mHandle, ctypes.create_string_buffer(primitiveId.encode('utf-8')), ctypes.byref(outResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outResource, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outResource.value, ownHandle=True)

    @staticmethod
    def sNewFromFile(parent : SDAPIObject, filePath : str, embedMethod : EmbedMethod) -> SDResourceScene:
        """
        Create a new SDResourceScene from the specified file. The resource will reference this file

        :param parent: The parent data that will contains the newly created Resource. Can be SDPackage or SDResourceFolder
        :param filePath: The scene file path
        :param embedMethod: The embed method. The only supported method is Linked
        """
        outResource = ctypes.c_void_p()
        _res = sd.getContext().SDResourceScene_sNewFromFile(parent.mHandle, ctypes.create_string_buffer(filePath.encode('utf-8')), embedMethod.value, ctypes.byref(outResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outResource, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outResource.value, ownHandle=True)

